using UnityEngine;
#if UNITY_EDITOR
    using UnityEditor;
#endif

public class HiveLogger
{

    private static bool isEnabled;

    // MenuItem
    #if UNITY_EDITOR
    [MenuItem("Hive/Hive Debug Log", true)]
    public static bool sync()
    {
        bool isOn = UnityEditor.Menu.GetChecked("Hive/Hive Debug Log");
        isEnabled = isOn;
        UnityEditor.Menu.SetChecked("Hive/Hive Debug Log", isEnabled);
        return true;
    }
    [MenuItem("Hive/Hive Debug Log", false)]
    public static void toggle()
    {
        isEnabled = !isEnabled;
        UnityEditor.Menu.SetChecked("Hive/Hive Debug Log", isEnabled);
        Debug.Log($"Hive Debug Log isEnabled: {isEnabled}");
    }
    #endif

    // Editor Log
    public static void Log(object message)
    {
        if (isEnabled) Debug.Log(message);
    }

    public static void LogWarning(object message)
    {
        if (isEnabled) Debug.LogWarning(message);
    }

    public static void LogError(object message)
    {
        if (isEnabled) Debug.LogError(message);
    }

}